<?php

namespace App\Http\Controllers\Invoice;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\InteriorDesigner;
use App\Models\Invoice;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class IndexController extends Controller
{

    public function __construct(Invoice $invoice)
    {
        $this->modelObject = $invoice;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = [
            'columns' => $this->modelObject->getGridColumns(),
            'dataset' => $this->modelObject->list(),
        ];
        return $this->view('invoice/list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $customerObj = new Customer;

        $data = [
            'customers' => $customerObj->getCustomerAsOptions(),
            'interior_designers' => (new InteriorDesigner)->getInteriorDesignersAsOptions()
        ];
        return $this->view('invoice/create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $validationRules = [
            'customer_id' => 'required',
        ];
        if ($data['address']['customer_address_id'] == ''){
            $validationRules['address.customer_address_id'] = 'required';
        }
        
        if ($data['address']['customer_address_id'] == '0') {
            $validationRules['address.address_line_1'] = 'required';
            $validationRules['address.address_line_2'] = 'required';
            $validationRules['address.city'] = 'required';
            $validationRules['address.state'] = 'required';
            $validationRules['address.postal_code'] = 'required';
            $validationRules['address.country'] = 'required';
        }
        $request->validate($validationRules,[
            'customer_id.required' => 'Please select customer',
            'address.customer_address_id.required' => 'Please select address',
            'address.address_line_1.required' => 'This field is required',
            'address.address_line_2.required' => 'This field is required',
            'address.city.required' => 'This field is required',
            'address.state.required' => 'This field is required',
            'address.postal_code.required' => 'This field is required',
            'address.country.required' => 'This field is required',
        ]);


        $invoice = $this->modelObject->saveRecord($request->all());
        return redirect()->intended(route('invoices.index'))->with($invoice['success'] ? 'success' : 'error', $invoice['message']);
    }

    /**
     * Display the specified resource.
     */
    public function show(Invoice $invoice)
    {
        return $this->modelObject->getDetails($invoice->invoice_id);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Invoice $invoice)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Invoice $invoice)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Invoice $invoice)
    {
        //
    }

     public function pdf($invoice_id,Request $request){
        return $this->modelObject->getPdf($invoice_id);
    }

}
