<?php

namespace App\Http\Controllers\Invoice\Item;

use App\Models\Invoice\Item;
use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;

class IndexController extends Controller
{

    public function __construct(Item $item)
    {
        $this->modelObject = $item;
    }

    public function index(Request $request)
    {
        $data = ['invoice_id' => $request->invoice];
        return $this->view('invoice/item/list', $data);
    }

    public function store($invoice_id,Request $request){
        $data = $request->all();
        $data['invoice_id'] = $invoice_id;
        return $this->modelObject->saveRecord($data);
    }

    public function destroy(Invoice $invoice,Item $item){
        return $this->modelObject->remove($item->invoice_item_id);
    }

    public function reorder(Request $request){
        return $this->modelObject->reorder($request->all());
    }
    
}
