<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureBusinessDetailsFilled
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        

        // Assume user has one business or business details in a model like $user->business
        if (!$user || !$user->business_name) {
            // Redirect to the business details form route
            return redirect()->route('business.edit');
        }

        return $next($request);
    }
}
