<?php

namespace App\Models;

use App\Traits\HasUuid;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class BaseModel extends Model
{
    use HasUuid;

    public function load($id){
        return self::find($id);
    }

    public function setSelect($queryBuilder = '')
    {
        if ($queryBuilder != '') {
            $this->queryBuilder = $queryBuilder;
        } else {
            $this->queryBuilder = '';
            $this->queryBuilder = $this->query();
        }
        return $this;
    }
    
    public function addOrderby($table, $field, $order)
    {
        $this->queryBuilder->orderBy($table.'.'.$field, $order);

        return $this;
    }


    public function addFieldToFilter($table, $column, $operator, $value)
    {
        switch ($operator) {

            case '=':
                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '=', $value);
                }
                break;
            case '!=':
                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '<>', $value);
                }
                break;

            case 'like':
                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, 'like', '%'.$value.'%');
                }
                break;

            case 'notlike':
                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, 'NOT LIKE', '%'.$value.'%');
                }
                break;

            case 'between':
                if (is_array($value)) {
                    if (count($value) > 0) {
                        $start_date = isset($value[0]) ? $value[0] : '';
                        $end_date = isset($value[1]) ? $value[1] : '';
                        if ($start_date != '' && $end_date != '') {
                            $start_date .= ' 00:00:00';
							$end_date .= ' 23:59:59';
                            $this->queryBuilder->where($table.'.'.$column, '>=', $start_date);
                            $this->queryBuilder->where($table.'.'.$column, '<=', $end_date);
                        }
                    }
                }
                break;
          case 'price_range':
                if (is_array($value)) {
                    if (count($value) > 0) {
                        $from_value = $value['from_value'];
                        $to_value = $value['to_value'];
                        if ($from_value != '') {
                            $this->queryBuilder->where($table.'.'.$column, '>=', $from_value);
                        }
                        if ($to_value != '') {
                            $this->queryBuilder->where($table.'.'.$column, '<=', $to_value);
                        }
                    }
                }
                break;
            case '>':

                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '>', $value);
                }
                break;
            case '>=':

                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '>=', $value);
                }
                break;

            case '<':

                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '<', $value);
                }
                break;
            case '<=':

                if (! is_array($value)) {
                    $this->queryBuilder->where($table.'.'.$column, '<=', $value);
                }
                break;
            case 'in':
                if (is_array($value)) {
                    $this->queryBuilder->whereIn($table.'.'.$column, $value);
                }
                break;
            case 'notin':
                if (is_array($value)) {
                    $this->queryBuilder->whereNotIn($table.'.'.$column, $value);
                }
                break;

            default:

        }

        return $this;
    }
    
    public function get($selectColoumn = ['*'])
    {
        return $this->queryBuilder->get($selectColoumn);
    }

    protected function getSQLQueryAsString($selectedColumns=[])
	{	
		if(!empty($selectedColumns)){
			$this->queryBuilder->select($selectedColumns);
		}
		$addSlashes = str_replace('?', "'?'", $this->queryBuilder->toSql());
		
		return vsprintf(str_replace('?', '%s', $addSlashes), $this->queryBuilder->getBindings());
	}


    public function getAuthUser(){
        if(Auth::check()){
            return Auth::user();
        }
        return null;
    }

    public function addAuthId(&$data = []){
        $authUser = $this->getAuthUser();
        $data['user_id'] = $authUser->user_id;
        
    }

    public function getAuthId(){
        $authUser = $this->getAuthUser();
        return $authUser->user_id;
    }

    public function validate($data,$rules,$message = []){
        $response = ['success' => true,'messages' => []];
        $validator = Validator::make($data,$rules,$message);
        if($validator->fails()){
            $response['success'] = false;
            $response['messages'] = $validator->errors()->all();
        }
        return $response;
    }

}
