<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Customer extends BaseModel
{
    protected $primaryKey = 'customer_id';
    protected $table = 'customers';
    
    protected $fillable = [
        'name',
        'email',
        'mobile',
        'user_id'
    ];

    public function getGridColumns($type = 'main'){
        $columns = [];
        $columns[] = ['label' => 'NAME','field' => 'name'];
        $columns[] = ['label' => 'MOBILE','field' => 'mobile'];
        $columns[] = ['label' => 'EMAIL','field' => 'email'];
        return $columns;
    }

    public function saveRecord($data = []){
        $response = ['success' => false,'message' => 'Failed to create customer.'];
        $this->addAuthId($data);
        $customer = self::create($data);
        $response['success'] = true;
        $response['message'] = 'customer created successfully.';
        return $response;
    }

    public function list(){
        $selectedColumns = [
            $this->table.'.customer_id as id',
            $this->table.'.*'
        ];
        $this->setSelect();
        $this->addFieldToFilter($this->table,'user_id','=',$this->getAuthId());
        return $this->get($selectedColumns);
    }

    public function getCustomerAsOptions(){
        $selectedColumns = [
            $this->table.'.customer_id as value',
            $this->table.'.name as label',
        ];
        $this->setSelect();
        $this->addFieldToFilter($this->table,'user_id','=',$this->getAuthId());
        return $this->get($selectedColumns);
    }

    
}
