<?php

namespace App\Models;

class InteriorDesigner extends BaseModel
{
    protected $primaryKey = 'interior_designer_id';
    protected $table = 'interior_designers';

    protected $fillable = [
        'name',
        'mobile',
        'email',
        'user_id',
    ];

    public function getGridColumns($type = 'main'){
        $columns = [];
        $columns[] = ['label' => 'NAME','field' => 'name'];
        $columns[] = ['label' => 'MOBILE','field' => 'mobile'];
        $columns[] = ['label' => 'EMAIL','field' => 'email'];
        return $columns;
    }

    public function list(){
        $selectedColumns = [
            $this->table.'.interior_designer_id as id',
            $this->table.'.*'
        ];
        $this->setSelect();
        $this->addFieldToFilter($this->table,'user_id','=',$this->getAuthId());
        return $this->get($selectedColumns);
    }

    public function saveRecord($data = []){
        $response = ['success' => false,'message' => 'Failed to create Interior Designer.'];
        $this->addAuthId($data);
        $desiner = self::create($data);
        $response['success'] = true;
        $response['message'] = 'Interior Designer created successfully.';
        return $response;
    }

    public function getInteriorDesignersAsOptions(){
        $selectedColumns = [
            $this->table.'.interior_designer_id as value',
            $this->table.'.name as label',
        ];
        $this->setSelect();
        $this->addFieldToFilter($this->table,'user_id','=',$this->getAuthId());
        return $this->get($selectedColumns);
    }

}
