import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { A as AppLayout } from "./app-layout-Cq2dk1dx.js";
import { Head } from "@inertiajs/react";
import { G as GridView } from "./grid-view-BAvJPkXa.js";
import Checkbox from "@mui/material/Checkbox";
import Paper from "@mui/material/Paper";
import Table from "@mui/material/Table";
import TableBody from "@mui/material/TableBody";
import TableCell from "@mui/material/TableCell";
import TableContainer from "@mui/material/TableContainer";
import TableHead from "@mui/material/TableHead";
import TableRow from "@mui/material/TableRow";
import { useState, useEffect } from "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "lucide-react";
import "./app-logo-icon-CoogQ1E6.js";
import "clsx";
import "tailwind-merge";
import "@radix-ui/react-dialog";
import "@radix-ui/react-tooltip";
import "@radix-ui/react-dropdown-menu";
import "@radix-ui/react-avatar";
import "@mui/material/Alert";
import "@mui/material/Box";
import "@mui/material/Grid";
function TableView({ columns = [], dataset = [], showSelection = false }) {
  const [tableColumn, setTableColumns] = useState([]);
  const [tableData, setTableData] = useState([]);
  const [selectedRecords, setSelectedRecords] = useState([]);
  const onSelectAllClick = (e) => {
    if (e.target.checked) {
      setSelectedRecords(tableData.map((record) => record.id));
    } else {
      setSelectedRecords([]);
    }
  };
  const onSelectClick = (e, id) => {
    if (e.target.checked) {
      setSelectedRecords([...selectedRecords, id]);
    } else {
      setSelectedRecords(selectedRecords.filter((localID) => localID != id));
    }
  };
  useEffect(() => {
    setTableColumns(columns);
    setTableData(dataset);
  }, [columns, dataset]);
  return /* @__PURE__ */ jsxs(TableContainer, { component: Paper, children: [
    JSON.stringify(selectedRecords),
    /* @__PURE__ */ jsxs(Table, { sx: { minWidth: 650 }, "aria-label": "simple table", children: [
      /* @__PURE__ */ jsx(TableHead, { children: /* @__PURE__ */ jsxs(TableRow, { children: [
        showSelection && /* @__PURE__ */ jsx(TableCell, { padding: "checkbox", children: /* @__PURE__ */ jsx(
          Checkbox,
          {
            color: "primary",
            indeterminate: selectedRecords.length > 0 && selectedRecords.length < dataset.length,
            checked: dataset.length > 0 && selectedRecords.length === dataset.length,
            onChange: onSelectAllClick
          }
        ) }),
        tableColumn.map((column) => /* @__PURE__ */ jsx(TableCell, { children: column.label }))
      ] }) }),
      /* @__PURE__ */ jsx(TableBody, { children: tableData.map((record) => /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(TableRow, { children: /* @__PURE__ */ jsxs(Fragment, { children: [
        showSelection && /* @__PURE__ */ jsx(TableCell, { padding: "checkbox", children: /* @__PURE__ */ jsx(
          Checkbox,
          {
            color: "primary",
            checked: selectedRecords.includes(record.id),
            onChange: (e) => onSelectClick(e, record.id)
          }
        ) }),
        tableColumn.map((column) => /* @__PURE__ */ jsx(TableCell, { children: record[column.field] ?? "-" }))
      ] }) }, record.id) })) })
    ] })
  ] });
}
const breadcrumbs = [
  {
    title: "Customers",
    href: "/customers"
  }
];
function Dashboard({ columns = [], dataset = [] }) {
  const [tableColumn, setTableColumns] = useState([]);
  const [tableData, setTableData] = useState([]);
  useEffect(() => {
    setTableColumns(columns);
    setTableData(dataset);
  }, [columns, dataset]);
  return /* @__PURE__ */ jsxs(AppLayout, { breadcrumbs, children: [
    /* @__PURE__ */ jsx(Head, { title: "Customers" }),
    /* @__PURE__ */ jsxs(GridView, { title: "Customers", children: [
      /* @__PURE__ */ jsx(GridView.Title, { children: "Hemant Jangid" }),
      /* @__PURE__ */ jsx(GridView.Action, { children: "Hemant Jsdsdsddsdsdsdangid" }),
      /* @__PURE__ */ jsx(GridView.Body, { children: /* @__PURE__ */ jsx(TableView, { columns: tableColumn, dataset: tableData, showSelection: true }) })
    ] })
  ] });
}
export {
  Dashboard as default
};
