<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('estimate_sections', function (Blueprint $table) {
            $table->uuid('estimate_section_id')->primary();
            $table->uuid('estimate_id');
            $table->string('title');
            $table->foreign('estimate_id')->references('estimate_id')->on('estimates')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('estimate_sections');
    }
};
