import { Link } from '@inertiajs/react';
import Button from '@mui/material/Button';

export default function ButtonJbs(props) {
    const variant = props.variant ?? 'outlined';
    const openInNewTab = props.newtab ?? false;
    const size = props.size ?? 'small';

    return (
        <>
            {props.href ? (
                <>
                    {openInNewTab && (
                        <a href={props.href} target="_blank" {...props}>
                            <Button size={size} {...props} variant={variant}>
                                {props.children ?? 'Button Text'}
                            </Button>
                        </a>
                    )}
                    {!openInNewTab && (
                        <Link href={props.href}>
                            <Button size={size} {...props} variant={variant}>
                                {props.children ?? 'Button Text'}
                            </Button>
                        </Link>
                    )}
                </>
            ) : (
                <Button {...props} variant={variant}>
                    {props.children ?? 'Button Text'}
                </Button>
            )}
        </>
    );
}
