import Alert from '@mui/material/Alert';
import Box from '@mui/material/Box';
import Grid from '@mui/material/Grid';
import getSlot from './slots';
import Typography from '@mui/material/Typography';

const Title = ({ children }) => <>{children}</>;
Title.displayName = 'GridView.Title';

const Action = ({ children }) => <>{children}</>;
Action.displayName = 'GridView.Action';

const Body = ({ children }) => <>{children}</>;
Body.displayName = 'GridView.Body';

const GridView = (props) => {
    const { children } = props;

    const title = getSlot(children, Title.displayName);
    const action = getSlot(children, Action.displayName);
    const body = getSlot(children, Body.displayName);

    return (
        <Box sx={{ flexGrow: 1 }}>
            <Grid container spacing={2}>
                <Grid size={{ xs: 8, md: 8 }}>
                <Typography variant="h6" gutterBottom>
                        {title}
                </Typography>
                </Grid>
                <Grid size={{ xs: 4, md: 4 }}>{action}</Grid>
                <Grid size={{ xs: 12, md: 12 }}>{body}</Grid>
            </Grid>
        </Box>
    );
};

GridView.Title = Title;
GridView.Action = Action;
GridView.Body = Body;
export default GridView;
