import FormControl from '@mui/material/FormControl';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import Select from '@mui/material/Select';
import { Add } from '@mui/icons-material';

export default function SelectJbs(props) {
    const options = props.options??[];
    const create = props.create ?? false;
    return (
        <FormControl fullWidth>
            <InputLabel>{props.label}</InputLabel>
            <Select className="w-full" {...props}>
                {options && options.map((item) => (
                    <MenuItem key={item.value} value={item.value}>
                        {item.label}
                    </MenuItem>
                ))}
                {create && (
                    <MenuItem key="0" value="0">
                        <Add /> Add New {props.label}
                    </MenuItem>
                )}
            </Select>
        </FormControl>
    );
}
