import AppLayoutTemplate from '@/layouts/app/app-sidebar-layout';
import { type BreadcrumbItem } from '@/types';
import { type ReactNode } from 'react';
import { BrowserRouter } from 'react-router-dom';
import Alert from '@mui/material/Alert';

interface AppLayoutProps {
    children: ReactNode;
    breadcrumbs?: BreadcrumbItem[];
}

export default ({ children, breadcrumbs, ...props }: AppLayoutProps) => {
    return (        
        <AppLayoutTemplate breadcrumbs={breadcrumbs} {...props}>
        <Alert severity="warning">UNDER DEVELOPEMENT.</Alert>
        {children}
        </AppLayoutTemplate>
    )
};
