import InputError from '@/components/input-error';
import ButtonJbs from '@/components/jbs/button';
import FormView from '@/components/jbs/form-view';
import InputJbs from '@/components/jbs/input';
import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { Head, useForm } from '@inertiajs/react';
import { Add, Close } from '@mui/icons-material';
import Grid from '@mui/material/Grid';
import Typography from '@mui/material/Typography';
import { LoaderCircle } from 'lucide-react';
import { FormEventHandler } from 'react';

const breadcrumbs: BreadcrumbItem[] = [
    {
        title: 'Customers',
        href: '/customers',
    },
    {
        title: 'Create',
        href: '#',
    },
];
type CustomerForm = {
    name: string;
    email: string;
    mobile: string;
};

export default function Create() {
    const { data, setData, post, processing, errors, reset } = useForm<Required<CustomerForm>>({
        name: '',
        mobile: '',
        email: '',
    });

    const submit: FormEventHandler = (e) => {
        e.preventDefault();
        post(route('customers.store'), {
            onFinish: () => reset('password', 'password_confirmation'),
        });
    };

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title="Create Customer" />
            <FormView>
                <FormView.Title>
                    <Typography variant="h6" gutterBottom>
                        Create Customer
                    </Typography>
                </FormView.Title>
                <FormView.Body>
                    <form onSubmit={submit}>
                        <Grid container spacing={2}>
                            <Grid size={12}>
                                <InputJbs
                                    id="name"
                                    autoFocus
                                    tabIndex={1}
                                    autoComplete="name"
                                    value={data.name}
                                    onChange={(e) => setData('name', e.target.value)}
                                    disabled={processing}
                                    label="Customer Name"
                                />
                                <InputError message={errors.name} className="mt-2" />
                            </Grid>
                            <Grid size={12}>
                                <InputJbs label="Customer Mobile" value={data.mobile} onChange={(e) => setData('mobile', e.target.value)} />
                                <InputError message={errors.mobile} className="mt-2" />
                            </Grid>
                            <Grid size={12}>
                                <InputJbs label="Customer Email" value={data.email} onChange={(e) => setData('email', e.target.value)} />
                                <InputError message={errors.email} className="mt-2" />
                            </Grid>
                            <Grid size={12}>
                                <ButtonJbs type="submit" startIcon={<Add />} disabled={processing}>
                                    {processing && <LoaderCircle className="h-4 w-4 animate-spin" />}
                                    Create
                                </ButtonJbs>
                                <ButtonJbs style={{ marginLeft: '10px' }} color="error" href={route('customers.index')} startIcon={<Close />}>
                                    Cancel
                                </ButtonJbs>
                            </Grid>
                        </Grid>
                    </form>
                </FormView.Body>
            </FormView>
        </AppLayout>
    );
}
