import AlertBox from '@/components/jbs/alert-box';
import ButtonJbs from '@/components/jbs/button';
import GridView from '@/components/jbs/grid-view';
import TableView from '@/components/jbs/table-view';
import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { Head, usePage } from '@inertiajs/react';
import { Add } from '@mui/icons-material';
import { useEffect, useState } from 'react';
import { ButtonGroup } from 'rsuite';

const breadcrumbs: BreadcrumbItem[] = [
    {
        title: 'Estimates',
        href: '#',
    },
];

export default function Dashboard({ columns = [], dataset = [] }) {
    const { flash } = usePage().props as { flash: { success?: string } };

    const [tableColumn, setTableColumns] = useState([]);

    const [tableData, setTableData] = useState([]);

    useEffect(() => {
        setTableColumns(columns);
        setTableData(dataset);
    }, [columns, dataset]);

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title="Estimates" />
            <AlertBox flash={flash} />
            <GridView title="Estimates">
                <GridView.Title>Estimates</GridView.Title>
                <GridView.Action>
                    <ButtonJbs href={route('estimates.create')} startIcon={<Add />}>
                        Add
                    </ButtonJbs>
                </GridView.Action>
                <GridView.Body>
                    <TableView
                        columns={tableColumn}
                        dataset={tableData}
                        showSelection={true}
                        action={true}
                        renderers={{
                            action: (value, record) => (
                                <>
                                    <ButtonGroup variant="outlined" >
                                        <ButtonJbs variant="text" href={route('estimates.items.index', { estimate: record.estimate_id })}> ITEMS </ButtonJbs>
                                        <ButtonJbs variant="text" href={route('estimates.pdf', { estimate: record.estimate_id })} newtab> PDF </ButtonJbs>
                                    </ButtonGroup>
                                </>
                            ),
                        }}
                    />
                </GridView.Body>
            </GridView>
        </AppLayout>
    );
}
