import ButtonJbs from '@/components/jbs/button';
import GridView from '@/components/jbs/grid-view';
import TableView from '@/components/jbs/table-view';
import AppLayout from '@/layouts/app-layout';
import { type BreadcrumbItem } from '@/types';
import { Head,usePage } from '@inertiajs/react';
import { Add } from '@mui/icons-material';
import { useEffect, useState } from 'react';
import AlertBox from '@/components/jbs/alert-box';

const breadcrumbs: BreadcrumbItem[] = [
    {
        title: 'Interior Designers',
        href: '/interior-designers',
    },
];

export default function Dashboard({ columns = [], dataset = [] }) {


    const { flash } = usePage().props as { flash: { success?: string } };

    const [tableColumn, setTableColumns] = useState([]);

    const [tableData, setTableData] = useState([]);

    useEffect(() => {
        setTableColumns(columns);
        setTableData(dataset);
    }, [columns, dataset]);

    return (
        <AppLayout breadcrumbs={breadcrumbs}>
            <Head title="Interior Designers" />
            <AlertBox flash={flash}/>
            <GridView title="Interior Designers">
                <GridView.Title>Interior Designers</GridView.Title>
                <GridView.Action>
                    <ButtonJbs href={route('interior-designers.create')} startIcon={<Add />}>
                        Add
                    </ButtonJbs>
                </GridView.Action>
                <GridView.Body>
                    <TableView columns={tableColumn} dataset={tableData} showSelection={true} />
                </GridView.Body>
            </GridView>
        </AppLayout>
    );
}
