<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estimate <?php echo e($estimate_number_display); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
        }

        .estimate-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }

        .company-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .estimate-info {
            display: table-cell;
            width: 50%;
            text-align: right;
            vertical-align: top;
        }

        .company-logo {
            max-width: 200px;
            max-height: 80px;
            margin-bottom: 10px;
        }

        .company-name {
            font-size: 20px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .company-details {
            font-size: 11px;
            color: #666;
            line-height: 1.5;
        }

        .estimate-title {
            font-size: 24px;
            font-weight: bold;
            color: #e74c3c;
            margin-bottom: 10px;
        }

        .estimate-details {
            font-size: 11px;
        }

        .estimate-details strong {
            color: #2c3e50;
        }

        .billing-section {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }

        .bill-to,
        .ship-to {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding-right: 20px;
        }

        .section-title {
            font-size: 14px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 10px;
            border-bottom: 2px solid #e74c3c;
            padding-bottom: 5px;
        }

        .address {
            font-size: 11px;
            line-height: 1.5;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .items-table th {
            background-color: #2c3e50;
            color: white;
            padding: 12px 8px;
            text-align: left;
            font-size: 11px;
            font-weight: bold;
        }

        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #ddd;
            font-size: 11px;
        }

        .items-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .totals-section {
            width: 300px;
            margin-left: auto;
            margin-bottom: 30px;
        }

        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }

        .totals-table td {
            padding: 8px 12px;
            border-bottom: 1px solid #ddd;
            font-size: 11px;
        }

        .totals-table .total-label {
            text-align: right;
            font-weight: bold;
            width: 60%;
        }

        .totals-table .total-amount {
            text-align: right;
            width: 40%;
        }

        .grand-total {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            font-size: 12px;
        }

        .notes-section {
            margin-bottom: 20px;
        }

        .notes-title {
            font-size: 12px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .notes-content {
            font-size: 10px;
            color: #666;
            line-height: 1.5;
        }

        .footer {
            border-top: 2px solid #e74c3c;
            padding-top: 15px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .payment-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .payment-title {
            font-size: 12px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 8px;
        }

        .payment-details {
            font-size: 10px;
            line-height: 1.5;
        }

        @media print {
            .estimate-container {
                padding: 0;
            }

            body {
                font-size: 11px;
            }
        }
    </style>
</head>

<body>
    <div class="estimate-container">
        <!-- Header Section -->
        <div class="header">
            <div class="company-info">
                <div class="company-name"><?php echo e($business_name); ?></div>
                <div class="company-details">
                    <b><?php echo e($user_name); ?></b><br>
                    <b>Phone:</b> <a href="tel:<?php echo e($user_mobile); ?>"><?php echo e($user_mobile); ?></a><br>
                    <b>Email:</b> <a href="mailto:<?php echo e($user_email); ?>"><?php echo e($user_email); ?></a><br>
                </div>
            </div>
            <div class="estimate-info">
                <div class="estimate-title">Estimate</div>
                <div class="estimate-details">
                    <strong>Estimate :</strong> <?php echo e($estimate_number_display); ?><br>
                    <strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($created_at)->format('M d, Y')); ?><br>
                </div>
            </div>
        </div>

        <!-- Billing Information -->
        <div class="billing-section">
            <div class="bill-to">
                <div class="section-title">Bill To:</div>
                <div class="address">
                    <strong><?php echo e($customer_name); ?></strong><br>
                    <?php echo $customer_address; ?> <br>
                    Phone: <a href="tel:<?php echo e($customer_mobile); ?>"><?php echo e($customer_mobile); ?></a><br>
                    <?php if(!empty($customer_email)): ?>
                        Email: <a href="mailto:<?php echo e($customer_email); ?>"><?php echo e($customer_email); ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php if(!empty($interior_designer_name)): ?>
                <div class="bill-to">
                    <div class="section-title">Interior Designer:</div>
                    <div class="address">
                        <strong><?php echo e($interior_designer_name); ?></strong><br>
                        Phone: <a href="tel:<?php echo e($interior_designer_mobile); ?>"><?php echo e($interior_designer_mobile); ?></a><br>
                        <?php if(!empty($interior_designer_email)): ?>
                            Email: <a href="mailto:<?php echo e($interior_designer_email); ?>"><?php echo e($interior_designer_email); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

        </div>

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th style="text-transform:uppercase;width: 5%;">#</th>
                    <th style="text-transform:uppercase;width: 30%;">Item Name</th>
                    <th style="text-transform:uppercase;width: 13%;" class="text-center">Unit</th>
                    <th style="text-transform:uppercase;width: 20%;" class="text-center">Dimensions</th>
                    <th style="text-transform:uppercase;width: 8%;" class="text-center">Qty</th>
                    <th style="text-transform:uppercase;width: 15%;" class="text-right">Unit Price</th>
                    <th style="text-transform:uppercase;width: 9%;" class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $total = 0;
                    $sr = 1;
                ?>
                <?php if(!empty($sections) && count($sections) > 0): ?>
                    <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th colspan="7" style="text-transform:uppercase"><?php echo e($section->title); ?></th>
                        </tr>
                        <?php if(!empty($section->items) && count($section->items) > 0): ?>
                            <?php $__currentLoopData = $section->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($sr); ?></td>
                                    <td>
                                        <b><?php echo e($item->item_name); ?></b> <br>
                                        <small><?php echo nl2br($item->description); ?></small>
                                    </td>

                                    <td><?php echo e($item->unit_type); ?></td>
                                    <td>
                                        <?php
                                            $dimensions = [];

                                            if (!empty($item->length_value) && !empty($item->length_unit)) {
                                                $dimensions[] = "({$item->length_value} {$item->length_unit})";
                                            }

                                            if (!empty($item->width_value) && !empty($item->width_unit)) {
                                                $dimensions[] = "({$item->width_value} {$item->width_unit})";
                                            }

                                            if (!empty($item->height_value) && !empty($item->height_unit)) {
                                                $dimensions[] = "({$item->height_value} {$item->height_unit})";
                                            }
                                        ?>
                                        <?php if(empty($dimensions)): ?>
                                            -
                                        <?php else: ?>
                                            <?php echo e(implode('×', $dimensions)); ?>< </td>
                                        <?php endif; ?>
                                    <td><?php echo e($item->quantity); ?></td>
                                    <td><?php echo e(money($item->unit_price)); ?></td>
                                    <td><?php echo e(money($item->total)); ?></td>
                                    <?php
                                        $total += $item->total;
                                        $sr += 1;
                                    ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!empty($sections) && count($sections) > 1): ?>
                                <tr>
                                    <td colspan="5"></td>
                                    <td style="color:blue;text-align:right">
                                        <b>Total</b>
                                    </td>
                                    <td style="color:blue">
                                        <?php echo e(money(collect($section->items)->sum('total'))); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan=7">No Items</td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7"> No Data Found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Totals Section -->
        <div class="totals-section">
            <table class="totals-table">
                <tr>
                    <td class="total-label">Subtotal:</td>
                    <td class="total-amount"><?php echo e(money($total)); ?></td>
                </tr>

                <tr class="grand-total">
                    <td class="total-label">Total:</td>
                    <td class="total-amount"><?php echo e(money($total)); ?></td>
                </tr>
            </table>
        </div>

        <!-- Payment Information -->
        <div class="payment-info">
            <div class="payment-title">UNIT</div>
            <div class="payment-details">
                <strong>RFT=</strong>RUNNING FOOT &nbsp;&nbsp;&nbsp;
                <strong>SQFT=</strong>SQUARE FOOT &nbsp;&nbsp;&nbsp;
                <strong>PCS=</strong>PEACE &nbsp;&nbsp;&nbsp;
                <strong>KG=</strong>KILOGRAM &nbsp;&nbsp;&nbsp;
            </div>
        </div>
        <?php if(!empty($notes)): ?>
            <div class="payment-info">
                <div class="payment-title">NOTES</div>
                <div class="payment-details">
                    <?php echo nl2br($notes); ?>

                </div>
            </div>
        <?php endif; ?>

        <!-- Footer -->
        <div class="footer">
            <strong>Thank you for your business!</strong><br>
            This Estimate was generated on <?php echo e(\Carbon\Carbon::parse($created_at)->format('M d, Y')); ?> at
            <?php echo e(\Carbon\Carbon::parse($created_at)->format('h:m A')); ?>

        </div>
    </div>
</body>

</html>
<?php /**PATH /Users/hemant/Desktop/larajbs/resources/views/pdf/estimate.blade.php ENDPATH**/ ?>